<?php
defined('PF_VERSION') OR exit('Access denied');
add_toolbar_button(form_button("<i class='glyphicon glyphicon-plus'></i> " . __('New Menu', 'menu'), array('onclick' => "window.location = '" . $_SERVER["REQUEST_URI"] . "&act=once'", 'class' => 'btn btn-primary')));
?>
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-list"></i> <?php echo __('Menu', 'menu'); ?></h3>
    </div>
    <div class="panel-body">
        <div class="row">
            <div class="col-md-8">
                <div class="btn-group pull-left btnGroupBulkAction" id="action-box">
                    <button type="button" class="btn btn-default btn-md btn-flat dropdown-toggle" data-toggle="dropdown">
                        <?php echo __('Select Action', 'menu'); ?> <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu" role="menu" id="bulkAction">
                        <li><a href="#" onclick="confirmaction('delete')"><?php echo __('Delete', 'menu'); ?></a></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 search-form">
                <form name="search" method="get" action="" class="form-inline">
                    <div class="input-group">
                        <input type="hidden" name="admin-page" value="menu" />
                        <input type="text" class="form-control" name="menu-name" placeholder="<?php echo __('Please enter menu name', 'menu'); ?>" value='<?php if (!empty($_GET['menu-name'])) {
                            echo $_GET['menu-name'];
                        } ?>'>
                        <span class="input-group-btn">
                            <button class="btn btn-default" type="submit" id="btnSearch">
                                <i class="fa fa-search"></i> <?php echo __('Search', 'menu'); ?>
                            </button>
                            <a class="btn btn-default" href="<?php echo admin_url('admin-page=menu', false) ?>">
                                <i class="fa fa-times-circle"></i>
                            </a>
                        </span>
                    </div>
                </form>
            </div>
        </div>
        <div class="row padding10-0">
            <div class="col-sm-3">
                
            </div>
            <div class="col-sm-9">
                <!-- Pagination -->
                <?php echo $pages->short_page_link();?>					<!-- Pagination -->
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <form method=post action='' id='checkform'>
                    <input type="hidden" id='action' name="action" />
                    <div class="table-responsive">
                        <table class="bootstrap-table">
                            <thead>
                                <tr>
                                    <th data-fixed="left" class='width40'><label><input type='checkbox' id='checkall' name='checkall' /> </label></th>
                                    <th class="width400"><?php echo __('Menu Name', 'menu'); ?></th>
                                    <th class="width400"><?php echo __('Shortcode', 'menu'); ?></th>
                                    <th data-fixed="right" class="width100"><?php echo __('Actions', 'menu'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
<?php if (!empty($list)) { ?>
    <?php foreach ($list as $menu) { ?>
                                        <tr>
                                            <td> <input type='checkbox' name='cid[]' value=' <?php echo $menu['id']; ?> ' class='checkbox' /></td>
                                            <td><?php echo htmlspecialchars($menu['name']) ?></td>
                                            <td>{pf:menu id=<?php echo $menu['id']; ?> }</td>
                                            <td>
                                                <a class="btn btn-info btn-xs" href="<?php echo admin_url('act=once&menu-id=' . $menu['id']); ?>">
                                                    <i class="fa fa-pencil-square-o"></i> <?php echo __('Edit', 'menu'); ?>
                                                </a> 
                                                <a class="btn btn-danger btn-xs" onclick="delete_menu('<?php echo admin_url('action=delete&id=' . $menu['id']); ?>');
                                                                        return;">
                                                    <i class="fa fa-times-circle"></i> <?php echo __('Delete', 'menu'); ?></a>
                                            </td>
                                        </tr>
    <?php } ?>
<?php } ?>
                            </tbody>
                        </table>
                    </div>
                </form>
                <div class="box-footer clearfix">
                    <div class="row">
                        <div class="col-md-6 col-md-offset-6">
                            <div class="pull-right">
                                <div class="pull-right">
                                    <div class="row">
                                        <div class="col-md-12" class="alignright">

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="panel-footer">
        <div class="row">
            <div class="col-sm-6">
                <?php echo $pages->page_lable(); ?>
            </div>
            <div class="col-sm-6">
                <!-- Pagination -->
                <?php echo $pages->page_links($org_url . '&'); ?>
                <!-- Pagination -->
            </div>
        </div>
    </div>
</div>
<div id="addnew" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="false" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title" id="myModalLabel"><?php echo __('Add Menu', 'menu'); ?></h4>
            </div>
            <form name="add" method="post" action="" class="form-horizontal">
                <input type="hidden" name="admin-page" value="user-manager">
                <div class="modal-body">
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><?php echo __('Menu Title', 'menu'); ?></label>
                        <div class="col-sm-8">
                            <input type="text" class="form-control" name="title" id="title" value="">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><?php echo __('Publish', 'menu'); ?></label>
                        <div class="col-sm-8">
                            <select class="form-control" name="publish">
                                <option value="1"><?php echo __('Yes', 'menu'); ?></option>
                                <option value="0"><?php echo __('No', 'menu'); ?></option>                   
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal" name="add"><?php echo __('Close', 'menu'); ?></button>
                    <button type="submit" name="add" class="btn btn-primary"><?php echo __('Add new', 'menu'); ?></button>
                </div>
            </form>    
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<script>
    function delete_menu(url) {
        $.sModal({
            image: '<?php echo RELATIVE_PATH; ?>/admin/plugins/theme/layouts/images/confirm.png',
            content: '<?php echo __('Are you sure to delete this item?', 'menu'); ?>',
            animate: 'fadeDown',
            buttons: [
                {
                    text: '<i class="fa fa-times-circle"></i> <?php echo __('Delete', 'menu'); ?> ',
                    addClass: 'btn-danger',
                    click: function(id, data) {
                        window.location = url;
                        $.sModal('close', id);
                    }
                },
                {
                    text: ' <?php echo __('Cancel', 'menu'); ?> ',
                    click: function(id, data) {
                        $.sModal('close', id);
                    }
                },
            ]
        });
    }
    function confirmaction(act) {
        $.sModal({
                image: '<?php echo RELATIVE_PATH; ?>/admin/plugins/theme/layouts/images/confirm.png',
                content: '<?php echo __('Are you sure with this action?', 'menu'); ?>',
                animate: 'fadeDown',
                buttons: [
                    {
                        text: '<i class="fa fa-times-circle"></i> <?php echo __('Confirm', 'menu'); ?> ',
                        addClass: 'btn-danger',
                        click: function(id, data) {
                           $('#action').val(act);
                           $('#checkform').submit();
                            $.sModal('close', id);
                        }
                    },
                    {
                        text: ' <?php echo __('Cancel', 'menu'); ?> ',
                        click: function(id, data) {
                            $.sModal('close', id);
                        }
                    },
                ]
            });
    }
</script>